package ru.yandex.chemodan.app.djfs.core.changelog;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.lang.DefaultObject;

@BenderBindAllFields
public class ChangelogZData extends DefaultObject {
    public static final BenderParserSerializer<ChangelogZData> B =
            new BenderMapper(BenderConfiguration.defaultConfiguration()).createParserSerializer(ChangelogZData.class);

    public Option<String> key = Option.empty();
    public Option<String> type = Option.empty();
    public Option<String> op = Option.empty();

    public String fid;

    @BenderPart(name = "public")
    public int publik;
    public int visible;

    public Option<String> sha256 = Option.empty();
    public Option<String> md5 = Option.empty();
    public Option<Long> size = Option.empty();

    public Option<String> mimetype = Option.empty();
    @BenderPart(name = "media_type", strictName = true)
    public Option<String> mediaType = Option.empty();
    public Option<Integer> drweb = Option.empty();

    @BenderPart(name = "has_preview", strictName = true)
    public Option<Boolean> has_preview = Option.empty();

    @BenderPart(name = "external_setprop", strictName = true)
    public Option<Integer> external_setprop = Option.empty();

    @BenderPart(name = "new_key", strictName = true)
    public Option<String> newKey = Option.empty();

    public Option<Long> etime = Option.empty();
    public Option<Long> mtime = Option.empty();
}
