package ru.yandex.chemodan.app.djfs.core.changelog;

import com.mongodb.client.model.Filters;
import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

public class MongoChangelogDao extends MongoShardedDao<ObjectId, MongoChangelog> implements ChangelogDao {

    public MongoChangelogDao(MongoShardedDaoContext dependencies) {
        super(dependencies, "changelog", "changelog", MongoChangelog.B);
    }

    public ListF<Changelog> findAll(DjfsUid uid) {
        return collectionX(uid).find(Filters.eq("uid", uid.asString())).map(MongoChangelog::to);
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        collectionX(uid).deleteMany(Filters.eq("uid", uid.asString()));
    }

    @Override
    public void insert(Changelog changelog) {
        if (changelog.getOperationType().equals(Changelog.OperationType.MOVED)) {
            throw new NotImplementedException();
        }

        collectionX(changelog.getUid()).insertOne(MongoChangelog.cons(changelog));
    }

    @Override
    public void insert(DjfsUid uid, ListF<Changelog> changelogs) {
        throw new NotImplementedException();
    }
}
