package ru.yandex.chemodan.app.djfs.core.client;

import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.lenta.BaseMordaBlockData;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;



@BenderBindAllFields
@ToString(callSuper = true)
public class DataapiMordaBlock extends BaseMordaBlockData {

    @BenderPart(strictName = true, name = "subtype")
    private final Option<String> subtype;

    @BenderPart(strictName = true, name = "title_en")
    private final Option<String> titleEn;
    @BenderPart(strictName = true, name = "title_ru")
    private final Option<String> titleRu;
    @BenderPart(strictName = true, name = "title_tr")
    private final Option<String> titleTr;
    @BenderPart(strictName = true, name = "title_uk")
    private final Option<String> titleUk;
    @BenderPart(strictName = true, name = "subtitle_en")
    private final Option<String> subtitleEn;
    @BenderPart(strictName = true, name = "subtitle_ru")
    private final Option<String> subtitleRu;
    @BenderPart(strictName = true, name = "subtitle_tr")
    private final Option<String> subtitleTr;
    @BenderPart(strictName = true, name = "subtitle_uk")
    private final Option<String> subtitleUk;
    @BenderPart(strictName = true, name = "photoslice_link_text_en")
    private final Option<String> photosliceLinkTextEn;
    @BenderPart(strictName = true, name = "photoslice_link_text_ru")
    private final Option<String> photosliceLinkTextRu;
    @BenderPart(strictName = true, name = "photoslice_link_text_tr")
    private final Option<String> photosliceLinkTextTr;
    @BenderPart(strictName = true, name = "photoslice_link_text_uk")
    private final Option<String> photosliceLinkTextUk;

    public DataapiMordaBlock(String id, String generationType, String bestResourceId, ListF<String> resourceIds, Instant minDate,
            Instant maxDate, String userTimezoneId, Instant mtime, Option<Instant> photosliceDate, Option<String> subtype,
            Option<String> titleEn, Option<String> titleRu, Option<String> titleTr, Option<String> titleUk,
            Option<String> subtitleEn, Option<String> subtitleRu, Option<String> subtitleTr, Option<String> subtitleUk,
            Option<String> photosliceLinkTextEn, Option<String> photosliceLinkTextRu, Option<String> photosliceLinkTextTr,
            Option<String> photosliceLinkTextUk) {
        super(id, generationType, bestResourceId, resourceIds, minDate, maxDate, userTimezoneId, mtime, photosliceDate);
        this.subtype = subtype;
        this.titleEn = titleEn;
        this.titleRu = titleRu;
        this.titleTr = titleTr;
        this.titleUk = titleUk;
        this.subtitleEn = subtitleEn;
        this.subtitleRu = subtitleRu;
        this.subtitleTr = subtitleTr;
        this.subtitleUk = subtitleUk;
        this.photosliceLinkTextEn = photosliceLinkTextEn;
        this.photosliceLinkTextRu = photosliceLinkTextRu;
        this.photosliceLinkTextTr = photosliceLinkTextTr;
        this.photosliceLinkTextUk = photosliceLinkTextUk;
    }

    public Option<String> getSubtype() {
        return subtype;
    }

    public Option<String> getTitleEn() {
        return titleEn;
    }

    public Option<String> getTitleRu() {
        return titleRu;
    }

    public Option<String> getTitleTr() {
        return titleTr;
    }

    public Option<String> getTitleUk() {
        return titleUk;
    }

    public Option<String> getSubtitleEn() {
        return subtitleEn;
    }

    public Option<String> getSubtitleRu() {
        return subtitleRu;
    }

    public Option<String> getSubtitleTr() {
        return subtitleTr;
    }

    public Option<String> getSubtitleUk() {
        return subtitleUk;
    }

    public Option<String> getPhotosliceLinkTextEn() {
        return photosliceLinkTextEn;
    }

    public Option<String> getPhotosliceLinkTextRu() {
        return photosliceLinkTextRu;
    }

    public Option<String> getPhotosliceLinkTextTr() {
        return photosliceLinkTextTr;
    }

    public Option<String> getPhotosliceLinkTextUk() {
        return photosliceLinkTextUk;
    }
}
