package ru.yandex.chemodan.app.djfs.core.client;

import lombok.RequiredArgsConstructor;
import lombok.Setter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsFileId;
import ru.yandex.chemodan.app.djfs.core.index.IndexerOrientation;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.geo.Coordinates;

@BenderBindAllFields
@Setter
@RequiredArgsConstructor
public class DiskSearchResponseItem {
    private final Option<String> id;

    @BenderPart(name = "cost_disk_aethetic_0", strictName = true)
    private final Option<String> aesthetics;

    private final Option<String> width;
    private final Option<String> height;
    private final Option<String> orientation;
    private final Option<String> latitude;
    private final Option<String> longitude;

    private static final StringEnumResolver<IndexerOrientation> R = StringEnumResolver.r(IndexerOrientation.class);

    public DjfsFileId getFileId() {
        return DjfsFileId.cons(id.get());
    }

    public Option<Double> getAesthetics() {
        return aesthetics.map(Double::parseDouble);
    }

    public int getWidth() {
        return Integer.parseInt(width.get());
    }

    public int getHeight() {
        return Integer.parseInt(height.get());
    }

    public IndexerOrientation getOrientation() {
        return R.valueOf(orientation.get());
    }

    public Option<Coordinates> getCoordinates() {
        if (!latitude.isPresent() || !longitude.isPresent()) {
            return Option.empty();
        }
        if (latitude.get().equals("0.0") && longitude.get().equals("0.0")) {
            return Option.empty();
        }
        return Option.of(new Coordinates(Double.parseDouble(latitude.get()), Double.parseDouble(longitude.get())));
    }
}
