package ru.yandex.chemodan.app.djfs.core.client;

import lombok.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.djfs.core.album.FaceInfo;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonParser;

@BenderBindAllFields
@Value
public class FaceClusterPhotos {
    @BenderPart(name = "cluster_id", strictName = true)
    String clusterId;

    /**
     * @todo Currently, values are strings or null, but they may be of any type in future.
     */
    ListF<MapF<String, /*nullable*/ String>> items;

    public ListF<FaceInfo> getItems() {
        return items.map(FaceInfo::new);
    }

    public static final BenderJsonParser<FaceClusterPhotos> jsonParser = Bender.jsonParser(FaceClusterPhotos.class);
}
