package ru.yandex.chemodan.app.djfs.core.client;

import lombok.Value;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.album.FaceInfo;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@BenderBindAllFields
@Value
public class FacesDelta {
    public enum Type {
        CLUSTER_CREATED,
        CLUSTER_DELETED,
        ITEM_ADDED,
        ITEM_DELETED,
    }

    Type type;

    @BenderPart(name = "cluster_id", strictName = true)
    String clusterId;

    /**
     * @todo Currently, values are strings or null, but they may be of any type in future.
     */
    @BenderPart(name = "resource", strictName = true)
    Option<MapF<String, /*nullable*/ String>> resource;

    public FaceInfo getAddedResource() {
        return resource.map(FaceInfo::new).getOrThrow("type:ITEM_ADDED delta must have .resource");
    }

    @BenderPart(name = "resource_id", strictName = true)
    Option<String> resourceId;

    public DjfsResourceId getDeletedResourceId() {
        return DjfsResourceId.cons(getResourceId().getOrThrow("type:ITEM_DELETED delta must have .resource_id"));
    }
}
