package ru.yandex.chemodan.app.djfs.core.client;

import lombok.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonParser;

@BenderBindAllFields
@Value
public class FacesDeltas {
    long version;

    ListF<FacesDelta> items;

    @BenderPart(name = "has_more", strictName = true)
    Boolean hasMore;

    public static final BenderJsonParser<FacesDeltas> jsonParser = Bender.jsonParser(FacesDeltas.class);
}
