package ru.yandex.chemodan.app.djfs.core.client;

import java.io.IOException;
import java.net.URI;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.Abstract200ExtendedResponseHandler;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;


public class LogReaderHttpClient {
    private final String baseUrl;
    private final HttpClient httpClient;

    private JsonParser responseParser = new JsonParser();

    public LogReaderHttpClient(String baseUrl, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.httpClient = httpClient;
    }

    public Option<Long> getCounter(String publicHash) {
        URI uri = UriBuilder
                .cons(baseUrl)
                .appendPath("/api/counters")
                .build();
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity(new StringEntity(
                "hashes=" + UrlUtils.urlEncode(publicHash), ContentType.APPLICATION_FORM_URLENCODED));
        JsonObject viewCounters = ApacheHttpClientUtils.execute(httpPost, httpClient, new LogReaderResponseHandler());

        Option<JsonValue> rawCountO = viewCounters.getO(publicHash);
        return rawCountO.map(JsonValue::serialize).map(Long::parseLong);
    }

    private class LogReaderResponseHandler extends Abstract200ExtendedResponseHandler<JsonObject> {
        @Override
        protected JsonObject handle200Response(HttpResponse response) throws IOException {
            return responseParser.parseObject(
                    InputStreamSourceUtils.wrap(response.getEntity().getContent()).readText()
            );
        }
    }
}
