package ru.yandex.chemodan.app.djfs.core.client;

import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@Value
@Builder
@BenderBindAllFields
public class OperationCallbackData {
    public static final BenderParserSerializer<OperationCallbackData> B =
            DjfsBenderFactory.createForJson(OperationCallbackData.class);

    private final String type;
    private final String status;
    private final String state;

    private final Params params;

    @BenderPart(name = "at_version", strictName = true)
    private final Long atVersion;

    @BenderBindAllFields
    @Builder
    public static class Params {
        @Builder.Default
        private final Option<String> source = Option.empty();
        @Builder.Default
        private final Option<String> target = Option.empty();
        @Builder.Default
        private final Option<String> path = Option.empty();
    }
}
