package ru.yandex.chemodan.app.djfs.core.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;

import ru.yandex.chemodan.util.bender.BenderUtils;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

public class OperationCallbackHttpClient {
    private final HttpClient httpClient;

    OperationCallbackHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public JsonObject makeJsonFromData(OperationCallbackData data) {
        return BenderUtils.toJsonObject(OperationCallbackData.B.getSerializer(), data);
    }

    public void doRequest(URI callbackUri, OperationCallbackData data) {
        String serializedData = makeJsonFromData(data).serialize();
        StringEntity postingString;
        try {
            postingString = new StringEntity(serializedData);
        } catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.translate(e);
        }

        HttpPost httpPost = new HttpPost(callbackUri);
        httpPost.setEntity(postingString);
        httpPost.setHeader("Content-type", "application/json");
        ApacheHttpClientUtils.execute(httpPost, httpClient, response -> true);
    }
}
