package ru.yandex.chemodan.app.djfs.core.db;

import java.lang.reflect.Proxy;

import ru.yandex.bolts.function.Function0;

/**
 * @author eoshch
 */
public class DaoProxyFactory {
    @SuppressWarnings("unchecked")
    public <T> T create(Class<T> type, T pgDao, T mongoDao, Function0<Boolean> dynamicIsUsePG) {
        return (T) Proxy.newProxyInstance(DaoProxyFactory.class.getClassLoader(), new Class[]{type},
                new DaoProxyInvocationHandler<>(pgDao, mongoDao, dynamicIsUsePG));
    }

    public <T> T create(Class<T> type, T pgDao) {
        return (T) this.create(type, pgDao, null, () -> true);
    }
}
