package ru.yandex.chemodan.app.djfs.core.db;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.ProxyInvocationHandlerBase;

/**
 * Проксирует вызов метода в нужную реалзиацию DAO в зависимости от того, переехало ли в PostgreSQL
 *
 * @author eoshch
 */
public class DaoProxyInvocationHandler<T> extends ProxyInvocationHandlerBase {
    private final T pgDao;
    private final T mongoDao;
    private final Function0<Boolean> isUsePg;

    public DaoProxyInvocationHandler(T pgDao, T mongoDao, Function0<Boolean> isUsePg) {
        this.pgDao = pgDao;
        this.mongoDao = mongoDao;
        this.isUsePg = isUsePg;
    }

    protected Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
        Sharded sharded = method.getDeclaredAnnotation(Sharded.class);
        if (sharded == null) {
            throw new NotImplementedException();
        }
        if (sharded.value() == Sharded.Request.SINGLE_SHARD) {
            /*
             * В будущем планируется прямо здесь определять шард пользователя и создавать DAO с указанием этого шарда.
             * Нужно для того, чтобы DAO изначально было шардированным и внутри себя уже с этим шардом работал.
             * Это нужно, например,
             * чтобы в будущем добавить аннотацию вида MULTI_SHARD, для хождения по нескольким шардам и тому подобное.
             */
            try {
                if (isUsePg.apply()) {
                    return method.invoke(pgDao, args);
                } else {
                    return method.invoke(mongoDao, args);
                }
            } catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        throw new NotImplementedException();
    }
}
