package ru.yandex.chemodan.app.djfs.core.db;

import lombok.Value;

/**
 * @author eoshch
 */
public interface DjfsShardInfo {

    default boolean isPg() {
        return false;
    }

    default boolean isMongo() {
        return false;
    }

    @Value
    class Mongo implements DjfsShardInfo {
        private final String shardId;

        @Override
        public boolean isMongo() {
            return true;
        }
    }

    @Value
    class Pg implements DjfsShardInfo {
        private final int shardId;

        @Override
        public boolean isPg() {
            return true;
        }
    }
}
