package ru.yandex.chemodan.app.djfs.core.db.mongo;

import java.util.UUID;

import org.bson.types.ObjectId;

import ru.yandex.chemodan.app.djfs.core.album.AlbumItemFieldValue;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItemFieldValueJsonSerializers;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.FileMetaPojo;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.FolderMetaPojo;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.ResourceMetaPojoMarshaller;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.SharedRights;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.SharedRightsMarshaller;
import ru.yandex.chemodan.util.bender.UnderscoreNamesBenderConfiguration;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.commune.json.bender.JsonValueUnmarshaller;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoObjectIdMarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.UuidMarshaller;
import ru.yandex.misc.bender.custom.UuidUnmarshaller;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author eoshch
 */
public class DjfsBenderFactory {

    public static final CustomMarshallerUnmarshallerFactoryBuilder defaultConfigurationBuilder = CustomMarshallerUnmarshallerFactoryBuilder
            .cons()
            .add(JsonValue.class, new JsonValueMarshaller(), new JsonValueUnmarshaller())
            .add(UUID.class, new UuidMarshaller(), new UuidUnmarshaller())
            .add(SharedRights.class, new SharedRightsMarshaller())
            .add(AlbumItemFieldValue.class, AlbumItemFieldValueJsonSerializers.consMarshaller())
            .add(ObjectId.class, new MongoObjectIdMarshaller(), new MongoDjfsIntegerUnmarshaller());

    public static final BenderConfiguration defaultConfiguration =
            new BenderConfiguration(BenderConfiguration.defaultSettings(), defaultConfigurationBuilder
                    .add(FileMetaPojo.class, ResourceMetaPojoMarshaller.createMarshaller(defaultConfigurationBuilder.build(), FileMetaPojo.class))
                    .add(FolderMetaPojo.class, ResourceMetaPojoMarshaller.createMarshaller(defaultConfigurationBuilder.build(), FolderMetaPojo.class))
                    .build());

    public static final BenderConfiguration mongoConfiguration =
            new BenderConfiguration(BenderConfiguration.defaultSettings(), CustomMarshallerUnmarshallerFactoryBuilder
                    .cons()
                    .add(JsonValue.class, new JsonValueMarshaller(), new JsonValueUnmarshaller())
                    .add(Integer.class, new MongoDjfsIntegerUnmarshaller())
                    .add(Long.class, new MongoDjfsLongUnmarshaller())
                    .build());

    public static final BenderMapper defaultMapper = new BenderMapper(defaultConfiguration);

    public static <TId, T> MongoBenderParserSerializer<TId, T> createForMongo(Class<T> clazz) {
        return MongoBenderParserSerializer.cons(clazz, mongoConfiguration);
    }

    public static <TId, T> MongoBenderParserSerializer<TId, T> createForMongoSnakeCase(Class<T> clazz) {
        return MongoBenderParserSerializer.cons(clazz, UnderscoreNamesBenderConfiguration.extend(mongoConfiguration));
    }

    public static <T> BenderParserSerializer<T> createForJson(Class<T> clazz) {
        return BenderParserSerializer.cons(ClassX.wrap(clazz), defaultConfiguration);
    }

    public static <T> BenderParserSerializer<T> createForJsonSnakeCase(Class<T> clazz) {
        return BenderParserSerializer.cons(ClassX.wrap(clazz),
                UnderscoreNamesBenderConfiguration.extend(defaultConfiguration));
    }
}
