package ru.yandex.chemodan.app.djfs.core.db.mongo;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.misc.thread.ParallelStreamSupplier;

/**
 * @author eoshch
 */
@Configuration
@Import({
        DjfsRealMongoContextConfiguration.class,
})
public class DjfsMongoContextConfiguration {
    @Bean
    @Qualifier("mongo")
    public ParallelStreamSupplier mongoParallelStreamSupplier(
            @Value("${mongo.parallel.min-threads}") int minThreads,
            @Value("${mongo.parallel.max-threads}") int maxThreads,
            @Value("${mongo.parallel.thread-keep-alive-seconds}") int keepAlive)
    {
        return ParallelStreamSupplier.builder()
                .minThreadCount(minThreads)
                .maxThreadCount(maxThreads)
                .invocationTimeoutMs(0)
                .keepAliveTimeSeconds(keepAlive)
                .threadNameFactory("MongoParallelStreamSupplierThread")
                .queueSize(0)
                .build();
    }

    @Bean
    public MongoShardResolver mongoShardResolver()
    {
        return new MongoShardResolver();
    }

    @Bean
    public MongoShardedDaoContext mongoShardedDaoContext(MongoShardResolver mongoShardResolver) {
        return new MongoShardedDaoContext(mongoShardResolver);
    }
}
