package ru.yandex.chemodan.app.djfs.core.db.mongo;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;

/**
 * @author eoshch
 */
@Configuration
@Profile(ActivateRealMongo.PROFILE)
public class DjfsRealMongoContextConfiguration {
    @Bean
    @Qualifier("common")
    @OverridableValuePrefix("common")
    public MongoClientProperties commonMongoClientProperties() {
        return new MongoClientProperties();
    }

    @Bean
    @Qualifier("blockings")
    @OverridableValuePrefix("blockings")
    public MongoClientProperties blockingsMongoClientProperties() {
        return new MongoClientProperties();
    }

    @Bean
    @Qualifier("sharded")
    @OverridableValuePrefix("sharded")
    public MongoClientProperties shardedMongoClientProperties() {
        return new MongoClientProperties();
    }

    @Bean
    @Qualifier("common")
    public MongoClient commonMongoClient(@Qualifier("common") MongoClientProperties mongoClientProperties,
            @Value("${common.mongo.host}") String host)
    {
        return new MongoClient(MongoUtil.parseHost(host), mongoClientProperties.toOptions());
    }

    @Bean
    @Qualifier("blockings")
    public MongoClient blockingsMongoClient(@Qualifier("blockings") MongoClientProperties mongoClientProperties,
            @Value("${blockings.mongo.host}") String host)
    {
        return new MongoClient(MongoUtil.parseHost(host), mongoClientProperties.toOptions());
    }

    @Bean
    @Qualifier("sharded")
    public MongoClientFactory shardedMongoClientFactory(
            @Qualifier("sharded") MongoClientProperties shardedMongoClientProperties)
    {
        return serverAddresses -> new MongoClient(serverAddresses, shardedMongoClientProperties.toOptions());
    }
}
