package ru.yandex.chemodan.app.djfs.core.db.mongo;

import java.util.concurrent.TimeUnit;

import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;

import ru.yandex.chemodan.app.djfs.core.db.mongo.logging.MongoClusterListener;
import ru.yandex.chemodan.app.djfs.core.db.mongo.logging.MongoCommandListener;
import ru.yandex.chemodan.app.djfs.core.db.mongo.logging.ReplicaSetCache;
import ru.yandex.chemodan.boot.value.OverridableValue;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
public class MongoClientProperties extends DefaultObject {
    @OverridableValue("${mongo.connections.per.host}")
    private int connectionsPerHost;

    @OverridableValue("${mongo.connect.timeout.ms}")
    private int connectTimeoutMs;

    @OverridableValue("${mongo.socket.timeout.ms}")
    private int socketTimeoutMs;

    @OverridableValue("${mongo.pool.timeout.ms}")
    private int poolWaitTimeoutMs;

    @OverridableValue("${mongo.threads.block.multiplier}")
    private int threadsAllowedToBlockForConnectionMultiplier;

    @OverridableValue("${mongo.w}")
    private int w;

    @OverridableValue("${mongo.fsync}")
    private boolean fsync;

    @OverridableValue("${mongo.wtimeout.ms}")
    private long wtimeoutMs;

    @OverridableValue("${mongo.read.preference}")
    private String readPreference;

    public MongoClientOptions toOptions() {
        ReplicaSetCache replicaSetCache = new ReplicaSetCache();
        return MongoClientOptions.builder()
                .connectionsPerHost(connectionsPerHost)
                .connectTimeout(connectTimeoutMs)
                .socketTimeout(socketTimeoutMs)
                .maxWaitTime(poolWaitTimeoutMs)
                .threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier)
                .writeConcern(WriteConcern.UNACKNOWLEDGED.withW(w).withWTimeout(wtimeoutMs, TimeUnit.MILLISECONDS)
                        .withJournal(fsync))
                .readPreference(ReadPreference.valueOf(readPreference))
                .addCommandListener(new MongoCommandListener(replicaSetCache))
                .addClusterListener(new MongoClusterListener(replicaSetCache))
                .build();
    }
}
