package ru.yandex.chemodan.app.djfs.core.db.mongo;

import org.w3c.dom.Node;

import ru.yandex.commune.mongo3.bender.MongoValueNode;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;

/**
 * MPFS database contains both Integer and String values in fields that supposed to be Integer.
 * That's why we need this custom unmarshaller that accepts both types.
 *
 * @author yappo
 */
public class MongoDjfsLongUnmarshaller implements FieldLevelUnmarshaller {

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {

        if (node.isNull()) {
            return ParseResult.result(null);
        }

        if (node instanceof MongoValueNode) {
            MongoValueNode mongo = (MongoValueNode) node;
            if (mongo.isNumber()) {
                return ParseResult.<Object>result(mongo.getNumberValueOrNull().longValue());
            }
            if (mongo.isString()) {
                return ParseResult.<Object>result(Long.parseLong(mongo.getString()));
            }
        }

        return ParseResult.<Object>result(node.getNumberValueOrNull().longValue());
    }

    @Override
    public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext context) {
        throw new IllegalStateException();
    }
}
