package ru.yandex.chemodan.app.djfs.core.db.mongo;

import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoShard extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoShard> B =
            DjfsBenderFactory.createForMongo(MongoShard.class);

    @MongoId
    public final String id;
    public final String host;
    public final boolean reg;

    @BenderPart
    @BenderDefaultValue("false")
    public final boolean system;

    public MongoShard(String id, String host, boolean reg, boolean system) {
        this.id = id;
        this.host = host;
        this.reg = reg;
        this.system = system;
    }
}
