package ru.yandex.chemodan.app.djfs.core.db.mongo;

import com.mongodb.MongoClient;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsShardInfo;
import ru.yandex.chemodan.app.djfs.core.db.UnknownShardException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.user.UserNotInitializedException;

/**
 * @author eoshch
 */
public class MongoShardResolver {
    private MapF<String, MongoClient> shardClients;

    public Option<MongoClient> resolveO(DjfsUid uid) { return Option.empty(); }

    public MongoClient resolve(DjfsUid uid) {
        throw new UserNotInitializedException(uid, "no shard for user");
    }

    public MongoClient resolve(DjfsShardInfo.Mongo shardInfo) {
        return shardClients.getO(shardInfo.getShardId()).getOrThrow(() -> new UnknownShardException(shardInfo));
    }

    public CollectionF<MongoClient> all() {
        return shardClients.values();
    }
}
