package ru.yandex.chemodan.app.djfs.core.db.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public abstract class MongoShardedDao<TId, TEntity> {
    private final MongoBenderParserSerializer<TId, TEntity> bender;
    private final MongoShardResolver mongoShardResolver;
    private final String databaseName;
    private final String collectionName;

    public MongoShardedDao(MongoShardedDaoContext context, String databaseName, String collectionName,
            MongoBenderParserSerializer<TId, TEntity> bender)
    {
        this.mongoShardResolver = context.mongoShardResolver;
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.bender = bender;
    }

    private MongoCollection<BsonDocument> collection(MongoClient mongoClient) {
        return mongoClient.getDatabase(databaseName).getCollection(collectionName, BsonDocument.class);
    }

    protected MongoCollection<BsonDocument> collection(DjfsUid uid) {
        return collection(mongoShardResolver.resolve(uid));
    }

    protected MongoCollection<BsonDocument> collection(DjfsUidSource uidSource) {
        return collection(uidSource.getUid());
    }

    private MongoCollectionX<TId, TEntity> collectionX(MongoClient mongoClient) {
        return new MongoCollectionX<>(collection(mongoClient), bender);
    }

    protected MongoCollectionX<TId, TEntity> collectionX(DjfsUid uid) {
        return collectionX(mongoShardResolver.resolve(uid));
    }

    protected MongoCollectionX<TId, TEntity> collectionX(DjfsUidSource uidSource) {
        return collectionX(uidSource.getUid());
    }

    protected ListF<MongoCollectionX<TId, TEntity>> collections() {
        return mongoShardResolver.all().map(this::collectionX);
    }
}
