package ru.yandex.chemodan.app.djfs.core.db.mongo.logging;

import java.util.HashSet;

import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.impl.ArrayListF;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author eoshch
 */
public class MongoClusterListener implements ClusterListener {
    private final ReplicaSetCache replicaSetCache;

    public MongoClusterListener(ReplicaSetCache replicaSetCache) {
        this.replicaSetCache = replicaSetCache;
    }

    @Override
    public void clusterOpening(ClusterOpeningEvent event) {
    }

    @Override
    public void clusterClosed(ClusterClosedEvent event) {
    }

    @Override
    public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
        ClusterDescription current = event.getNewDescription();

        Option<String> currentReplicaSetName = getReplicaSetName(current);
        ArrayListF<ServerAddress> currentAddressList = getServerAddressList(current);
        if (currentReplicaSetName.isPresent()) {
            replicaSetCache.update(currentReplicaSetName.get(), currentAddressList);
        }
    }

    private Option<String> getReplicaSetName(ClusterDescription clusterDescription) {
        if (clusterDescription.getType() != ClusterType.REPLICA_SET) {
            return Option.empty();
        }
        HashSet<String> replicaSetNames = new HashSet<>(clusterDescription.getServerDescriptions().size());
        for (ServerDescription serverDescription : clusterDescription.getServerDescriptions()) {
            String replicaSetName = serverDescription.getSetName();
            if (!StringUtils.isBlank(replicaSetName)) {
                replicaSetNames.add(replicaSetName);
            }
        }
        if (replicaSetNames.size() == 1) {
            return Option.wrap(replicaSetNames.stream().findAny());
        }
        return Option.empty();
    }

    private ArrayListF<ServerAddress> getServerAddressList(ClusterDescription clusterDescription){
        if (clusterDescription.getType() != ClusterType.REPLICA_SET) {
            return ArrayListF.valueOf(new ServerAddress [0]);
        }
        ArrayListF<ServerAddress> result = new ArrayListF<>(clusterDescription.getServerDescriptions().size());
        for (ServerDescription serverDescription : clusterDescription.getServerDescriptions()) {
            ServerAddress address = serverDescription.getAddress();
            if (address != null) {
                result.add(address);
            }
        }
        return result;
    }
}
