package ru.yandex.chemodan.app.djfs.core.db.mongo.logging;

import java.util.concurrent.ConcurrentHashMap;

import com.mongodb.ServerAddress;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.impl.ArrayListF;

/**
 * @author eoshch
 */
public class ReplicaSetCache {
    private final ConcurrentHashMap<ServerAddress, String> serverAddressToReplicaSetName = new ConcurrentHashMap<>();

    public void update(String replicaSetName, ArrayListF<ServerAddress> serverAddressList) {
        for (ServerAddress serverAddress : serverAddressList) {
            serverAddressToReplicaSetName.put(serverAddress, replicaSetName);
        }
    }

    public Option<String> resolve(ServerAddress serverAddress) {
        return Option.ofNullable(serverAddressToReplicaSetName.getOrDefault(serverAddress, null));
    }
}
