package ru.yandex.chemodan.app.djfs.core.db.pg;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;

import org.apache.commons.lang3.mutable.MutableInt;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.StringArrayEnum;
import ru.yandex.chemodan.app.djfs.core.StringIntCombinedEnum;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.spring.jdbc.ArgPreparedStatementSetter;

/**
 * @author eoshch
 */
public class DjfsArgPreparedStatementSetter extends ArgPreparedStatementSetter {
    public DjfsArgPreparedStatementSetter(Object[] args) {
        super(args);
    }

    @Override
    protected void setArg(PreparedStatement ps, Object arg, MutableInt pos) throws SQLException {
        if (arg instanceof Option) {
            setArg(ps, ((Option) arg).getOrNull(), pos);
        } else {
            super.setArg(ps, arg, pos);
        }
    }

    @Override
    protected void setSimpleArg(PreparedStatement ps, int pos, Object arg) throws SQLException {
        if (arg instanceof DjfsUid) {
            ps.setLong(pos, ((DjfsUid) arg).asLong());
        } else if (arg instanceof StringEnum) {
            ps.setObject(pos, ((StringEnum) arg).value(), Types.OTHER);
        } else if (arg instanceof StringArrayEnum) {
            ps.setString(pos, ((StringArrayEnum) arg).value());
        } else if (arg instanceof StringIntCombinedEnum) {
            ps.setObject(pos, ((StringIntCombinedEnum) arg).getStringRepresentation(), Types.OTHER);
        } else if (arg instanceof PgArray) {
            PgArray pgArray = (PgArray) arg;
            Array array = ps.getConnection().createArrayOf(pgArray.getType(), pgArray.getArray());
            try {
                ps.setArray(pos, array);
            } finally {
                array.free();
            }
        } else {
            super.setSimpleArg(ps, pos, arg);
        }
    }
}
