package ru.yandex.chemodan.app.djfs.core.db.pg;

import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.LoggingHttpInterceptor;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.SharpeiProperties;
import ru.yandex.chemodan.util.sharpei.SharpeiClient;
import ru.yandex.chemodan.util.sharpei.SharpeiHttpClient;

/**
 * @author eoshch
 */
@Configuration
@Profile(ActivateRealPg.PROFILE)
public class DjfsRealPgContextConfiguration {
    @Bean
    public SharpeiProperties SharpeiProperties() {
        return new SharpeiProperties();
    }

    @Bean
    public SharpeiClient sharpeiClient(SharpeiProperties properties) {
        HttpClient httpClient = sharpeiHttpClientConfigurator()
                .createBuilder()
                .withInterceptorLast((HttpRequestInterceptor) LoggingHttpInterceptor.MPFS_CLIENT_INTERCEPTOR)
                .withInterceptorFirst((HttpResponseInterceptor) LoggingHttpInterceptor.MPFS_CLIENT_INTERCEPTOR)
                .build();

        return new SharpeiHttpClient(properties.getSharpeiBaseUrl(), httpClient);
    }

    @Bean
    @OverridableValuePrefix("sharpei")
    public HttpClientConfigurator sharpeiHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }
}
