package ru.yandex.chemodan.app.djfs.core.db.pg;

import java.util.UUID;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class PgArray {
    private final String type;
    private final Object[] array;

    public static PgArray textArray(String... array) {
        return new PgArray("text", array);
    }

    public static PgArray byteaArray(byte[]... array) {
        return new PgArray("bytea", array);
    }

    public static PgArray uuidArray(UUID[]... array) {
        return new PgArray("uuid", array);
    }
}
