package ru.yandex.chemodan.app.djfs.core.db.pg;

import org.springframework.transaction.PlatformTransactionManager;

import ru.yandex.chemodan.app.djfs.core.db.DjfsShardInfo;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.user.UserNotInitializedException;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author eoshch
 */
public class PgShardResolver {
    private final ShardManager2 shardManager2;
    private final SharpeiShardResolver sharpeiShardResolver;

    public PgShardResolver(ShardManager2 shardManager2, SharpeiShardResolver sharpeiShardResolver) {
        this.shardManager2 = shardManager2;
        this.sharpeiShardResolver = sharpeiShardResolver;
    }

    public JdbcTemplate3 resolve(DjfsUid uid) {
        return shardManager2.getShard(sharpeiShardResolver.shardByUid(uid)
                .getOrThrow(() -> new UserNotInitializedException(uid, "no sharpei entry")).getShardId())
                .getJdbcTemplate3();
    }

    public JdbcTemplate3 resolve(DjfsShardInfo.Pg shardInfo) {
        return shardManager2.getShard(shardInfo.getShardId()).getJdbcTemplate3();
    }

    public PlatformTransactionManager transactionManager(DjfsUid uid) {
        return shardManager2.getShard(sharpeiShardResolver.shardByUid(uid)
                .getOrThrow(() -> new UserNotInitializedException(uid, "no sharpei entry")).getShardId())
                .getTransactionManager();
    }

    public PlatformTransactionManager transactionManager(DjfsShardInfo.Pg shardInfo) {
        return shardManager2.getShard(shardInfo.getShardId()).getTransactionManager();
    }
}
