package ru.yandex.chemodan.app.djfs.core.db.pg;

import ru.yandex.chemodan.app.djfs.core.db.DjfsShardInfo;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author eoshch
 */
public abstract class PgShardedDao {
    private final PgShardResolver pgShardResolver;

    public PgShardedDao(PgShardedDaoContext context) {
        this.pgShardResolver = context.pgShardResolver;
    }

    protected String collectStats(DjfsUidSource uidSource) {
        return collectStats(uidSource.getUid());
    }

    /**
     * Enables collecting PostgreSQL resource usage statistics by uid
     */
    protected String collectStats(DjfsUid uid) {
        return " /* uid:" + uid.asLong() + " */ ";
    }

    protected JdbcTemplate3 jdbcTemplate(DjfsShardInfo.Pg shardInfo) {
        return pgShardResolver.resolve(shardInfo);
    }

    protected JdbcTemplate3 jdbcTemplate(DjfsUid uid) {
        return pgShardResolver.resolve(uid);
    }

    protected JdbcTemplate3 jdbcTemplate(DjfsUidSource uidSource) {
        return jdbcTemplate(uidSource.getUid());
    }
}
