package ru.yandex.chemodan.app.djfs.core.db.pg;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.util.sharpei.ShardUserInfo;
import ru.yandex.chemodan.util.sharpei.SharpeiManager;
import ru.yandex.chemodan.util.sharpei.SimpleUserId;
import ru.yandex.commune.db.shard.proxy.Discriminant;
import ru.yandex.commune.db.shard.spring.ShardResolver;

/**
 * @author eoshch
 */
public class SharpeiShardResolver implements ShardResolver {

    private final SharpeiManager sharpeiCachingManager;

    public SharpeiShardResolver(SharpeiManager sharpeiCachingManager) {
        this.sharpeiCachingManager = sharpeiCachingManager;
    }

    public Option<ShardUserInfo> shardByUid(DjfsUid uid) {
        return sharpeiCachingManager.find(new SimpleUserId(uid.asString()), true);
    }

    @Override
    public int shardByDiscriminant(Discriminant discriminant) {
        throw new NotImplementedException();
    }
}
