package ru.yandex.chemodan.app.djfs.core.db.pg;

import lombok.RequiredArgsConstructor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@RequiredArgsConstructor
public class TransactionUtils {
    private static final TransactionDefinition defaultTransactionDefinition;

    static {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setIsolationLevel(TransactionDefinition.ISOLATION_READ_COMMITTED);
        defaultTransactionDefinition = transactionDefinition;
    }

    private final PgShardResolver pgShardResolver;

    public <T> T executeInNewOrCurrentTransaction(DjfsUid uid, Function0<T> action) {
        PlatformTransactionManager transactionManager = pgShardResolver.transactionManager(uid);
        TransactionTemplate transaction = new TransactionTemplate(transactionManager, defaultTransactionDefinition);
        return transaction.execute(action.asFunction()::apply);
    }

    public void executeInNewOrCurrentTransaction(DjfsUid uid, Function0V action) {
        executeInNewOrCurrentTransaction(uid, () -> {
            action.apply();
            return null;
        });
    }
}
