package ru.yandex.chemodan.app.djfs.core.diskinfo;

import java.util.UUID;

import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceType;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@Value
@Builder(toBuilder = true)
public class DiskInfo implements DjfsUidSource {
    public static String OVERDRAFT_RESET_COUNT_FIELD = "overdraft_reset_count";

    UUID id;

    @Builder.Default
    Option<UUID> parentId = Option.empty();

    DjfsUid uid;
    String path;
    DjfsResourceType type;

    // TODO: make type something like Option<Either<Long, MapF<String, Either<String, Integer>>>>
    @Builder.Default
    Option<DiskInfoData> data = Option.empty();

    @Builder.Default
    Option<Long> version = Option.empty();
}
