package ru.yandex.chemodan.app.djfs.core.diskinfo;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;

/**
 * @author eoshch
 */
@Configuration
@Import({DjfsDbContextConfiguration.class})
public class DiskInfoContextConfiguration {

    @Bean
    public MongoDiskInfoDao mongoDiskInfoDao(MongoShardedDaoContext dependencies) {
        return new MongoDiskInfoDao(dependencies);
    }

    @Bean
    public PgDiskInfoDao pgDiskInfoDao(PgShardedDaoContext dependencies) {
        return new PgDiskInfoDao(dependencies);
    }

    @Bean
    @Primary
    public DiskInfoDao diskInfoDaoProxy(DaoProxyFactory daoProxyFactory, MongoDiskInfoDao mongoDao,
            PgDiskInfoDao pgDao)
    {
        return daoProxyFactory.create(DiskInfoDao.class, pgDao);
    }

    @Bean
    public DiskInfoManager diskInfoManager(DiskInfoDao diskInfoDao) {
        return new DiskInfoManager(diskInfoDao);
    }

    @Bean
    public UserStateManager userStateManager() {
        return new UserStateManager();
    }
}
