package ru.yandex.chemodan.app.djfs.core.diskinfo;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public interface DiskInfoDao {
    @Sharded
    Option<DiskInfo> find(DjfsUid uid, String path);

    @Sharded
    ListF<DiskInfo> find(DjfsUid uid);

    @Sharded
    void insert(DiskInfo diskInfo);

    @Sharded
    Option<Long> findLimit(DjfsUid uid);

    @Sharded
    Option<Long> findTotalUsed(DjfsUid uid);

    @Sharded
    Option<Long> findTrashUsed(DjfsUid uid);

    @Sharded
    Option<Long> findFileCount(DjfsUid uid);

    @Sharded
    Option<DownloadTraffic> findDownloadTraffic(DjfsUid uid);

    @Sharded
    void incrementTotalUsed(DjfsUid uid, long delta);

    @Sharded
    void incrementTrashUsed(DjfsUid uid, long delta);

    @Sharded
    void setLimit(DjfsUid uid, long limit);

    @Sharded
    void setTotalUsed(DjfsUid uid, long used);

    @Sharded
    void setTrashUsed(DjfsUid uid, long used);

    @Sharded
    void insertOrUpdateDiskInfoValue(DiskInfo diskInfo);

    @Sharded
    void incrementResetOverdraftCounter(DjfsUid uid);

    @Sharded
    Option<Integer> getOverdraftCounter(DjfsUid uid);
}
