package ru.yandex.chemodan.app.djfs.core.diskinfo;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

public class DiskInfoData {

    public static DiskInfoData longData(long value) {
        return new DiskInfoData(Option.of(value), Option.empty(), Option.empty());
    }

    public static DiskInfoData jsonData(JsonData jsonData) {
        return new DiskInfoData(Option.empty(), Option.of(jsonData), Option.empty());
    }

    public static DiskInfoData rawData(String rawData) {
        return new DiskInfoData(Option.empty(), Option.empty(), Option.of(rawData));
    }

    private final Option<Long> longData;

    private final Option<JsonData> jsonData;

    private final Option<String> rawData;

    private DiskInfoData(Option<Long> longData, Option<JsonData> jsonData, Option<String> rawData) {
        this.longData = longData;
        this.jsonData = jsonData;
        this.rawData = rawData;
    }

    public boolean isLongData() {
        return longData.isPresent();
    }

    public boolean isJsonData() {
        return jsonData.isPresent();
    }

    public boolean isRawData() {
        return rawData.isPresent();
    }

    public Long getLongValue() {
        return longData.getOrThrow("Long value has not been set");
    }

    public JsonData getJsonData() {
        return jsonData.getOrThrow("JSON data has not been set");
    }

    public String getRawData() {
        return rawData.getOrThrow("Raw data has not been set");
    }

    @BenderBindAllFields
    @Data
    public static class JsonData {

        @BenderPart(name = "geo_albums_generation_in_progress", strictName = true)
        private final Option<Boolean> geoAlbumsGenerationInProgress;

    }


}
