package ru.yandex.chemodan.app.djfs.core.filesystem;

import java.util.Optional;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.web.JsonStringResult;
import ru.yandex.chemodan.cache.TimeLimitedCacheFast;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author eoshch
 */
@ActionContainer
public class FilesystemActions {
    private final Filesystem filesystem;
    private final SupportDao supportDao;
    private final TimeLimitedCacheFast<String, JsonStringResult> cache;

    public FilesystemActions(Filesystem filesystem, SupportDao supportDao, Function0<Integer> cacheTtl) {
        this.filesystem = filesystem;
        this.supportDao = supportDao;
        this.cache = TimeLimitedCacheFast.<String, JsonStringResult>builder()
                .cacheName("filesystem-actions")
                .initialCapacity(2^16)
                .loadFactor(0.6f)
                .ttl(cacheTtl)
                .build();
    }

    // todo: implement converter for MpfsUid ru.yandex.chemodan.app.commentaries.web.bind.ConverterToCommentId
    @Path(value = "/mkdir", methods = HttpMethod.GET)
    public void mkdir(@RequestParam("uid") String uid, @RequestParam("path") String path) {
        filesystem.createFolder(DjfsPrincipal.cons(DjfsUid.cons(uid)), DjfsResourcePath.cons(uid, path));
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.R_S)
    @Path(value = "/blocking", methods = HttpMethod.GET)
    public JsonStringResult blocking() {
        String cacheKey = "/blocking";
        Optional<JsonStringResult> fromCache = cache.getFromCache(cacheKey);
        if (fromCache.isPresent()) {
            return fromCache.get();
        }
        ListF<String> blockingStids = supportDao.getAllBlockedStids().map(s -> "/" + s);
        JsonStringResult result = new JsonStringResult(String.join("\n", blockingStids) + "\n");
        cache.putInCache(cacheKey, result);
        return result;
    }
}
