package ru.yandex.chemodan.app.djfs.core.filesystem;

import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@BenderBindAllFields
@Data
public class JsonSupportData {
    private final Option<String> uid;
    private final Option<Long> ctime;
    private final Option<String> address;
    private final Option<String> comment;
    private final Option<String> moderator;
    @BenderPart(name = "ext_link", strictName = true)
    private final Option<String> extLink;
    private final Option<String> view;
    private final Option<String> id;
    private final Option<String> hash;
    private final ListF<String> stids;

    public static JsonSupportData cons(JsonSupportData data, Option<String> id, Option<String> hash, ListF<String> stids) {
        return new JsonSupportData(
                data.getUid(),
                data.getCtime(),
                data.getAddress(),
                data.getComment(),
                data.getModerator(),
                data.getExtLink(),
                data.getView(),
                id,
                hash,
                stids
        );
    }
}
