package ru.yandex.chemodan.app.djfs.core.filesystem;

import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.base.AbstractInstant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.util.UuidUtils;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoSupportBlockedHid {
    public static final MongoBenderParserSerializer<ObjectId, MongoSupportBlockedHid> B =
            DjfsBenderFactory.createForMongo(MongoSupportBlockedHid.class);

    @MongoId
    public ObjectId id;
    @BenderPart(name = "block_type", strictName = true)
    public Option<String> block_type;
    public byte[] hid;
    public Option<DateTime> ctime;

    public SupportBlockedHid to() {
        return SupportBlockedHid.builder()
                .id(id)
                .block_type(block_type)
                .ctime(ctime.map(AbstractInstant::toInstant))
                .hid(UuidUtils.from(hid))
                .build();
    }
    public static MongoSupportBlockedHid cons(SupportBlockedHid supportBlockedHid) {
        MongoSupportBlockedHid result = new MongoSupportBlockedHid();
        result.id = supportBlockedHid.getId();
        result.block_type = supportBlockedHid.getBlock_type();
        result.hid = UuidUtils.toHexString(supportBlockedHid.getHid()).getBytes();
        result.ctime = supportBlockedHid.getCtime().map(x -> x.toDateTime(DateTimeZone.UTC));
        return result;
    }
}
