package ru.yandex.chemodan.app.djfs.core.filesystem;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;
import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.MongoCollectionX;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author eoshch
 */
public class MongoSupportBlockedHidsDao implements SupportBlockedHidsDao {
    /**
     * В монго тело запроса не может превышать 16 МБ(16777216байт)
     * Запрос с 375000 записей занимает 16763915байт
     * https://st.yandex-team.ru/CHEMODAN-34551
     */
    private static final int MONGO_CHUNK_SIZE = 375000;

    private final MongoCollectionX<ObjectId, MongoSupportBlockedHid> collection;

    public MongoSupportBlockedHidsDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("support_blocked_hids")
                        .getCollection("support_blocked_hids", BsonDocument.class),
                MongoSupportBlockedHid.B);
    }

    public Option<SupportBlockedHid> find(String hid) {
        BsonBinary binaryHid = new BsonBinary(BsonBinarySubType.OLD_BINARY, CharsetUtils.encodeUtf8ToArray(hid));
        return collection.findOne(Filters.eq("hid", binaryHid)).map(MongoSupportBlockedHid::to);
    }

    public ListF<SupportBlockedHid> find(ListF<String> hids) {
        ListF<ListF<BsonBinary>> hidsPages = hids
                .map(hid -> new BsonBinary(BsonBinarySubType.OLD_BINARY, CharsetUtils.encodeUtf8ToArray(hid)))
                .paginate(MONGO_CHUNK_SIZE);
        return hidsPages.map(h -> collection.find(Filters.in("hid", h)).map(MongoSupportBlockedHid::to)).flatten();
    }
}
