package ru.yandex.chemodan.app.djfs.core.filesystem;

import lombok.Value;
import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Bendable
@BenderBindAllFields
@Value
public class MongoSupportComment {

    public static final MongoBenderParserSerializer<ObjectId, MongoSupportComment> B =
            DjfsBenderFactory.createForMongo(MongoSupportComment.class);

    @MongoId
    public ObjectId id;
    public JsonSupportData data;
    public String uid;

    public SupportComment to() {
        return SupportComment.builder()
                .id(id)
                .data(JsonSupportData.cons(data, Option.empty(), Option.empty(), Cf.list()))
                .dataId(data.getId())
                .dataHash(data.getHash())
                .dataStids(data.getStids())
                .uid(DjfsUid.cons(uid))
                .build();
    }

    public static MongoSupportComment cons(SupportComment supportComment) {
        JsonSupportData jsonData = supportComment.getData();
        return new MongoSupportComment(
                supportComment.getId(),
                JsonSupportData.cons(
                        jsonData,
                        supportComment.getDataId(),
                        supportComment.getDataHash(),
                        supportComment.getDataStids()
                ),
                supportComment.getUid().toString()
        );
    }
}
