package ru.yandex.chemodan.app.djfs.core.filesystem;

import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;
import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.commune.mongo3.MongoCollectionX;

public class MongoSupportDao implements SupportDao {
    private final MongoCollectionX<ObjectId, MongoSupportComment> collection;

    public MongoSupportDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("support_mpfs")
                        .getCollection("support_mpfs", BsonDocument.class),
                MongoSupportComment.B);
    }

    @Override
    public Option<SupportComment> find(String hash) {
        return collection
                .findOne(Filters.eq("data.hash", hash), MongoSupportComment.B::parse)
                .map(MongoSupportComment::to);
    }

    @Override
    public SetF<String> getAllBlockedStids() {
        SetF<String> blockedStids = Cf.hashSet();

        ListF<MongoSupportComment> iter = collection.find(
                Filters.and(Filters.exists("data.stids"), Filters.ne("data.stids", null)),
                ReadPreference.secondary());

        iter.forEach(comment -> blockedStids.addAll(comment.getData().getStids()));
        return blockedStids;
    }

    @Override
    public void insert(SupportComment supportComment) {
        collection.insertOne(MongoSupportComment.cons(supportComment));
    }
}
