package ru.yandex.chemodan.app.djfs.core.filesystem;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.djfs.core.client.OperationCallbackData;
import ru.yandex.chemodan.app.djfs.core.client.OperationCallbackHttpClient;
import ru.yandex.chemodan.app.djfs.core.util.CeleryJobUtils;
import ru.yandex.chemodan.app.djfs.core.util.JsonUtils;
import ru.yandex.chemodan.queller.celery.job.CeleryJob;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonValue;

public class OperationCallbackHandler {

    public static final TaskId CALL_URL_TASK_ID = new TaskId("mpfs.core.job_handlers.routine.handle_call_url");

    private final OperationCallbackHttpClient operationCallbackHttpClient;
    private final CeleryTaskManager celeryTaskManager;

    public OperationCallbackHandler(OperationCallbackHttpClient operationCallbackHttpClient,
            CeleryTaskManager celeryTaskManager)
    {
        this.operationCallbackHttpClient = operationCallbackHttpClient;
        this.celeryTaskManager = celeryTaskManager;
    }

    public void submitCallbackTask(String callback, OperationCallbackData data) {
        JsonObject dataJson = operationCallbackHttpClient.makeJsonFromData(data);
        MapF<String, JsonValue> kwargs = JsonUtils.objectBuilder()
                .add("url", callback)
                .add("data", dataJson.serialize())  // string value is required here
                .toMap();
        CeleryJob celeryJob = CeleryJobUtils.create(CALL_URL_TASK_ID, kwargs);
        celeryTaskManager.submit(celeryJob, false);
    }
}
