package ru.yandex.chemodan.app.djfs.core.filesystem;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;


public class PgTrashCleanQueueDao extends PgShardedDao {
    private final static RowMapper<TrashCleanQueueTask> M = (rs, rowNum) -> new TrashCleanQueueTask(
            rs.getString("id"),
            DjfsUid.cons(rs.getLong("uid")),
            rs.getDate("bound_date")
    );

    public PgTrashCleanQueueDao(PgShardedDaoContext context) {
        super(context);
    }

    public void insert(TrashCleanQueueTask trashCleanQueueTask) {
        String sql = collectStats(trashCleanQueueTask.getUid())
                + " INSERT INTO disk.trash_cleaner_queue (id, bound_date, uid) VALUES(?, ?, ?) "
                + "ON CONFLICT (id) DO NOTHING";

        jdbcTemplate(DjfsUid.COMMON_UID).update(
                sql, trashCleanQueueTask.getId(), trashCleanQueueTask.getDate(), trashCleanQueueTask.getUid());
    }

    /**
     * Use in tests only!
     * Not ready for production!
     */
    public ListF<TrashCleanQueueTask> findAll(DjfsUid uid) {
        String sql = collectStats(uid) + " SELECT * FROM disk.trash_cleaner_queue WHERE uid = :uid";
        return jdbcTemplate(DjfsUid.COMMON_UID).query(sql, M, Cf.map("uid", uid));
    }
}
