package ru.yandex.chemodan.app.djfs.core.filesystem;

import java.text.SimpleDateFormat;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.digest.Md5;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Data
@EqualsAndHashCode(callSuper = true)
public class TrashCleanQueueTask extends DefaultObject implements DjfsUidSource {

    private final String id;
    private final DjfsUid uid;
    private final Date date;

    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");

    public TrashCleanQueueTask(DjfsUid uid, Date date) {
        this.id = Md5.A.digest(String.format("%s_%s", uid.asString(), DATE_FORMAT.format(date))).hex();
        this.uid = uid;
        this.date = date;
    }
}
