package ru.yandex.chemodan.app.djfs.core.filesystem.event;

import java.util.HashMap;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * Создана папка внутри публичной папки
 *
 * @author eoshch
 */
public class SharedFolderCreatedEvent extends FolderCreatedEvent {
    public ShareInfo shareInfo;
    public MapF<DjfsUid, Option<Long>> oldVersions;

    public SharedFolderCreatedEvent() {
        oldVersions = Cf.wrap(new HashMap<>());
    }

    @Override
    public Option<ShareInfo> getShareInfoO() {
        return Option.of(shareInfo);
    }
}
