package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class FolderTooDeepException extends LegacyMpfsException {
    public FolderTooDeepException() {
        super("Operation is not permitted due to exceeded directory depth limit");
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.FORBIDDEN;
    }

    @Override
    public int getCode() {
        return 295;
    }

    @Override
    public String getTitle() {
        return "folder depth limit exceeded";
    }

    @Override
    public String getPythonClassName() {
        return "FolderTooDeep";
    }
}
