package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsPrincipal;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FilesystemOperation;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public class NoPermissionException extends FilesystemException {
    public final DjfsPrincipal principal;
    public final FilesystemOperation operation;
    public final Option<DjfsUid> uid;
    public final Option<DjfsResourcePath> path;
    public final Option<ShareInfo> shareInfo;

    public NoPermissionException(DjfsPrincipal principal, FilesystemOperation operation, DjfsUid uid) {
        this(principal, operation, Option.of(uid), Option.empty(), Option.empty(), Option.empty());
    }

    public NoPermissionException(DjfsPrincipal principal, FilesystemOperation operation, DjfsUid uid,
            ShareInfo shareInfo)
    {
        this(principal, operation, Option.of(uid), Option.empty(), Option.of(shareInfo), Option.empty());
    }

    public NoPermissionException(DjfsPrincipal principal, FilesystemOperation operation, DjfsResourcePath path,
            Option<ShareInfo> shareInfo)
    {
        this(principal, operation, Option.empty(), Option.of(path), shareInfo, Option.empty());
    }

    public NoPermissionException(DjfsPrincipal principal, FilesystemOperation operation, Option<DjfsUid> uid,
            Option<DjfsResourcePath> path, Option<ShareInfo> shareInfo, Option<String> reason)
    {
        super(principal.toString() + " has no " + operation + " permission"
                + uid.map(x -> " for uid " + x.toString()).getOrElse("")
                + path.map(x -> " for path " + x.toString()).getOrElse("")
                + shareInfo.map(x -> " for group " + x.getGroupId()).getOrElse("")
                + reason.map(x -> " because " + x).getOrElse(""));
        this.principal = principal;
        this.uid = uid;
        this.path = path;
        this.shareInfo = shareInfo;
        this.operation = operation;
    }
}
