package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsPrincipal;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FilesystemOperation;

/**
 * @author eoshch
 */
public class OperationInAreaNotPermittedException extends FilesystemException {
    public final DjfsPrincipal principal;
    public final FilesystemOperation operation;
    public final DjfsResourcePath path;

    public OperationInAreaNotPermittedException(DjfsPrincipal principal, FilesystemOperation operation,
            DjfsResourcePath path)
    {
        super(principal.toString() + " has no " + operation + " area permission for path " + path.toString());
        this.principal = principal;
        this.path = path;
        this.operation = operation;
    }
}
