package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class OverdraftUserPublicLinkException extends LegacyMpfsException {
    public OverdraftUserPublicLinkException() {
        super("Overdraft user public link not allowed");
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.NOT_FOUND;
    }

    @Override
    public int getCode() {
        return 279;
    }

    @Override
    public String getTitle() {
        return "Overdraft user public link not allowed";
    }

    @Override
    public String getPythonClassName() {
        return "OverdraftUserPublicLinkDisabled";
    }
}
