package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsPrincipal;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FilesystemOperation;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public class PrincipalBlockedException extends NoPermissionException {
    public PrincipalBlockedException(DjfsPrincipal principal, FilesystemOperation operation, DjfsUid uid) {
        this(principal, operation, Option.of(uid), Option.empty(), Option.empty());
    }

    public PrincipalBlockedException(DjfsPrincipal principal, FilesystemOperation operation, DjfsUid uid,
            ShareInfo shareInfo)
    {
        this(principal, operation, Option.of(uid), Option.empty(), Option.of(shareInfo));
    }

    public PrincipalBlockedException(DjfsPrincipal principal, FilesystemOperation operation, DjfsResourcePath path,
            Option<ShareInfo> shareInfo)
    {
        this(principal, operation, Option.empty(), Option.of(path), shareInfo);
    }

    public PrincipalBlockedException(DjfsPrincipal principal, FilesystemOperation operation,
            Option<DjfsResourcePath> path, Option<ShareInfo> shareInfo)
    {
        this(principal, operation, Option.empty(), path, shareInfo);
    }

    public PrincipalBlockedException(DjfsPrincipal principal, FilesystemOperation operation, Option<DjfsUid> uid,
            Option<DjfsResourcePath> path, Option<ShareInfo> shareInfo)
    {
        super(principal, operation, uid, path, shareInfo, Option.of("principal is blocked"));
    }
}
