package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;

/**
 * @author eoshch
 */
public class ResourceExistsException extends FilesystemException {
    public final DjfsResourcePath path;

    public ResourceExistsException(DjfsResourcePath path) {
        super("Resource already exists for " + path.getFullPath());
        this.path = path;
    }

    public ResourceExistsException(DjfsResourcePath path, Throwable cause) {
        super("Resource already exists for " + path.getFullPath(), cause);
        this.path = path;
    }
}
